<!DOCTYPE html>
<html lang="en" @if(selected_lang()->rtl == 1) dir="rtl" @endif>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title> {{__('Invoice')}} | {{env('APP_NAME')}}</title>
  <meta name="csrf-token" content="{{ csrf_token() }}"><!-- CSRF Token -->
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link href="{{asset('css/font-awesome.min.css')}}" rel="stylesheet" type="text/css"/> <!-- fontawsome css -->
  <!-- Admin (main) Style Sheet -->
  <link rel="stylesheet" href="{{url('css/admin.css')}}">
</head>
<body class="hold-transition skin-blue sidebar-mini" style="background: #111">

<!-- Main content -->

@if (isset($invoice) && $invoice != null)

<section id="main-wrapper" class="main-wrapper invoice">
    <div class="container-fluid">
        <div class="panel-body">
            <!-- title row -->
            <div class="row">
                <div class="col-xs-12">
                    @php
                        $setting = App\Config::first();
                        $image = 'images/logo/'.$setting['logo'];
                        $imageData = base64_encode(@file_get_contents($image));
                        $src = $imageData ? 'data: '.mime_content_type($image).';base64,'.$imageData : null;
                        $gstAmount = ($invoice->price * $invoice->gst) / 100;
                        $amount = $invoice->price - $gstAmount;
                        $gamount = $invoice->price - $amount;
                    @endphp

                    <div class="invoice-logo">
                        @if($setting->logo != NULL && $src)
                            <img src="{{ $src }}" class="img-fluid" alt="logo">
                        @else
                            <a href="{{ url('/') }}"><b><div class="logotext">{{ $setting['title'] }}</div></b></a>
                        @endif
                    </div>
                    <br>
                    <p class="total-heading">{{ __('Purchased on') }}: {{ date('jS F Y', strtotime($invoice['created_at'])) }}</p>
                    <hr/>
                </div>
            </div>

            <!-- info row -->
            <div class="row">
                <div class="col-sm-4 col-md-4">
                    <b>{{__('From')}}:</b>
                    <address>
                        <strong>{{$gst->company_name}}</strong><br>
                        {{$invoice_add}}<br>
                        {{__('Gst Number')}}: {{$gst->gst_number}}<br>
                        {{__('Address')}}: {{$gst->address}}
                    </address>
                </div>

                <div class="col-xs-4 col-sm-4 col-md-4">
                    <b>{{__('To')}}:</b>
                    <address>
                        <strong>{{auth()->user()->name}}</strong><br>
                        {{__('Email')}}: {{auth()->user()->email}}
                    </address>
                </div>

                <div class="col-sm-4 col-md-4">
                    <b>{{__('Invoice')}}:</b> #{{$invoice->id}}<br>
                    <b>{{__('Order ID')}}:</b> {{$invoice->payment_id}}<br>
                    <b>{{__('Payment Mode')}}:</b> {{$invoice->payment_type}}<br>
                </div>
            </div>

            <br/>

            <!-- Table row -->
            <div class="row">
                <div class="col-xs-12 table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead style="color:#48A3c6;">
                            <tr>
                                <th>#</th>
                                <th>{{__('User Name')}}</th>
                                <th>{{__('Movie Name/Tv series Name')}}</th>
                                <th>{{__('Method')}}</th>
                                <th>{{__('Line Total')}}</th>
                            </tr>
                        </thead>
                        <tbody style="margin-top: 10px; background-color:#111;">
                            <tr style="background-color:#111;">
                                <td>1</td>
                                <td>{{auth()->user()->name}}</td>
                                <td>{{$invoice->tvseries->title ?? ''}}{{$invoice->movie->title ?? ''}}</td>
                                <td>{{$invoice->method}}</td>
                                <td>
                                    @if($invoice->gst == 1)
                                        <div><b>Amount:</b> {{strtoupper($currency_code)}} {{$amount}} </div>
                                        <div><b>GST %:</b> {{$invoice->gst}} %</div>
                                        <div><b>GST Amount:</b> {{strtoupper($currency_code)}} {{$gamount}}</div>
                                    @else
                                        <div><b>Total:</b> {{strtoupper($currency_code)}} {{$invoice->price}}</div>
                                    @endif
                                </td>
                            </tr>
                            <tr style="background-color:#111;">
                                <td colspan="3"></td>
                                <td class="total-heading">{{__('Grand Total')}}</td>
                                <td>{{strtoupper($currency_code)}} {{$invoice->price}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="row">
                <!-- accepted payments column -->
                <div class="col-xs-6">
                    @php
                        $visa_src = $mastercard_src = $express_src = $paypal2_src = null;

                        $visa = 'images/credit/visa.png';
                        $visaData = base64_encode(@file_get_contents($visa));
                        if ($visaData) $visa_src = 'data: '.mime_content_type($visa).';base64,'.$visaData;

                        $master = 'images/credit/mastercard.png';
                        $masterData = base64_encode(@file_get_contents($master));
                        if ($masterData) $mastercard_src = 'data: '.mime_content_type($master).';base64,'.$masterData;

                        $express = 'images/credit/american-express.png';
                        $expressData = base64_encode(@file_get_contents($express));
                        if ($expressData) $express_src = 'data: '.mime_content_type($express).';base64,'.$expressData;

                        $paypal = 'images/credit/paypal2.png';
                        $paypalData = base64_encode(@file_get_contents($paypal));
                        if ($paypalData) $paypal2_src = 'data: '.mime_content_type($paypal).';base64,'.$paypalData;
                    @endphp

                    <p class="lead">{{__('Payment Methods')}}:</p>
                    @if($visa_src)<img src="{{$visa_src}}" alt="Visa">@endif
                    @if($mastercard_src)<img src="{{$mastercard_src}}" alt="Mastercard">@endif
                    @if($express_src)<img src="{{$express_src}}" alt="American Express">@endif
                    @if($paypal2_src)<img src="{{$paypal2_src}}" alt="Paypal">@endif
                </div>
            </div>

            <p style="margin-top: 10px;">
                <div class="printbox col-12 text-justify">
                    <hr>
                    {{__('This is a computer-generated invoice and does not require a physical signature')}}.<br>
                    {{__('If you have any questions concerning this invoice, feel free to write to us at our email address')}}.
                </div>
            </p>
        </div>
    </div>
</section>

@endif
f

<!-- /.content -->
<div class="clearfix"></div>
<!-- ./wrapper -->
<script src="{{asset('js/jquery.min.js')}}" type="text/javascript"></script>
<script src="{{asset('js/admin.js')}}" type="text/javascript"></script>

</body>
</html>
